<?php
/**
 * 标签管理模型
 */
class Tag_Model extends Model {	
	
	public function __construct() {
		parent::__construct();	
	}	
	
	public function image($src, $width = 0, $height = 0, $type = 1) {
		if (Wee::$config['upload_dispatch']) {		
			$args = "$src,$width,$height,$type";
			$crc = substr(md5(Wee::$config['encrypt_key'].$args), 10, 6);
			$url = Wee::$config['web_url'] . 'attach.php?r=' . 
				Ext_String::base64UrlEncode("$args,$crc");
		} else {	
			$url = load_model('Attach')->makeImage($src, $width, $height, $type);
		}
		return $url;
	}
		
	public function article($cid, $star, $num = 10, $order = 'id') {
		$cacheKey = "article_{$cid}_{$star}_{$num}_{$order}";
		if ($cacheData = $this->cache->getFromBox($cacheKey)) {
			return $cacheData;
		} 
		if ($cid) {
			if (false !== strpos($cid, ',')) {
				$where['cid'] = explode(',', $cid);
			} else {
				$modCate = load_model('Cate');
				$cate = $modCate->getPlace($cid);
				if ($cate['sonId']) {
					$where['cid'] = $cate['sonId'];
					array_unshift($where['cid'], $cid);
				} else {
					$where['cid'] = $cid;
				}	
			}
		}	
		if ($star) {
			if (false !== strpos($star, ',')) {
				$where['star'] = explode(',', $star);
			} else {
				$where['star'] = $star;	
			}
		}
		if ('week' == $order) {
			$where[] = "addtime > " . time() - 7 * 24 * 3600;
			$order = 'hits';	
		}
		$articleMod = load_model('Article');	
		$articleList = $articleMod->search($where, $num, $order, 'DESC');
		$this->cache->setToBox($cacheKey, $articleList);
		return $articleList;		
	}	
	
	public function zhuanti($limit = '2') {
		$modTopic = load_model('Topic');
		$sTree = $modTopic->getList();
		$where['status'] = 1;
		$list = array();
		$list = $modTopic->search($where, $limit);
		return $list;
	}
	
	public function relevant($id, $limit = 5) {
		$modArticle = load_model('Article');
		$articleInfo = $modArticle->get($id);		
		$list = array();
		if ($articleInfo['tagArr']) {
			$res = $this->db->table('#@_tags')
					->where(array('tag' => $articleInfo['tagArr']))
					->limit($limit)
					->getAll();
			$ids = Ext_Array::cols($res, 'article_id');
			$where = array('id' => $ids);
			$list = $modArticle->search($where, $limit);
		}
		return $list;
	}
	
	public function tags($num = 20) {
		$cacheKey = "tags_$num";
		if ($cacheData = $this->cache->getFromFile($cacheKey)) {
			return $cacheData;	
		}
		$modArticle = load_model('Article');
		$tags = $modArticle->getTags($num);
		$this->cache->setToFile($cacheKey, $tags);
		return $tags;
	}
	
	public function match($str) {
		$str = preg_match("/[\x7f-\xff]/", $str);
		return $str;
	}
	
	public function searchurl($keyword) {
		return url('Search', '', array('keyword' => $keyword));
	}	
	
	public function tagsurl($tag) {
		return url('Tags', '', array('tag' => $tag));	
	}	
	
	public function tagsallurl() {
		return url('tags', 'all');
	}
	
	public function rssurl() {
		if (Wee::$config['url_html_maps']) {
			return Wee::$config['web_url'] . Wee::$config['url_dir_maps'] . '/rss.xml';
		} else {
			return url('maps', 'rss');
		}
	}
	
	public function sitemapurl() {
		if (Wee::$config['url_html_maps']) {
			return Wee::$config['web_url'] . Wee::$config['url_dir_maps'] . '/sitemap.xml';
		} else {
			return url('maps');	
		}
	}

	public function topicurl(){
		if (Wee::$config['url_mode']) {
			return Wee::$config['web_url'] . 'topic' . Wee::$config['url_suffix'];			
		} else {
			return Wee::$config['web_url'] . Wee::$config['url_index'] . '?c=Topic';
		}
	}

	public function systemurl($id) {
		$modSystem = load_model('System');
		if(!$id){
			$system = $modSystem->getList();
		}else{
			$system = $modSystem->getPlace($id);
		}
		return $system;
	}
	
	public function links($type = 0, $num = 100) {
		$cacheKey = "links_{$type}_{$num}";
		if ($cacheData = $this->cache->getFromFile($cacheKey)) {
			return $cacheData;
		}
		$where = array();
		if ($type) {
			$where['type'] = $type;
			$where['status'] = '1';
				
		}
		$linkList = load_model('Link')->getList($where, $num, 'oid ASC');
		$this->cache->setToFile($cacheKey, $linkList);
		return $linkList;
	}
	
	public function adsense($title) {	
	    $cKey = "Adsense_$title";
		$cData = $this->cache->getFromFile($cKey);
		if ($cData) {
			return $cData;	
		}
		$info   = load_model('Adsense')->getByTitle($title);
		$status = load_model('Adsense')->getByStatus($title);
		if ($status == '1'){
			if ($info){
				$this->cache->setToFile($cKey, $info['content']);
				return $info['content'];
			} else {
				return "<!-- $title:广告标识不存在 -->";	
			}
		}
	}
	
	/**
	* 自定义 header 函数，用于过滤可能出现的安全隐患
	* @param   string  string  内容
	* @return  void
	**/
	public function tutu_header($string, $replace = true, $http_response_code = 0) {
		$string = str_replace(array("\r", "\n"), array('', ''), $string);
		if (preg_match('/^\s*location:/is', $string))
		{
			@header($string . "\n", $replace);
			exit();
		}
		if (empty($http_response_code) || PHP_VERSION < '4.3')
		{
			@header($string, $replace);
		}else{
			@header($string, $replace, $http_response_code);
		}
	}

}